<?php
wp_enqueue_style('iv_directories-style-64', wp_iv_directories_URLPATH . 'assets/cube/css/cubeportfolio.css');
wp_enqueue_style('iv_directories-style-11222', wp_iv_directories_URLPATH . 'admin/files/css/listing-style.css');
require(wp_iv_directories_DIR .'/admin/files/css/color_style.php');
$current_post_type='';$post_type='';
if(isset($atts['post_type'])){
	$post_type =  sanitize_text_field(strtolower($atts['post_type']));
	$current_post_type=$post_type;
}
if($post_type!=''){
	$args = array(
			'post_type' => $current_post_type,
			'post_status' => 'publish',
			'posts_per_page'=> '-1',  
			);
	if(isset($atts['category'] )){
		$postcats = get_query_var($current_post_type.'-'.$atts['category']);
		$args[$current_post_type.'-category']=sanitize_text_field($atts['category']);
		$selected=$postcats;
		
	}
	if(isset($atts['post_limit']) and $atts['post_limit']!="" ){	 
		$args['posts_per_page']=$atts['post_limit'];
	}else{
		$args['posts_per_page']='9999';
		
	}
	if(isset($atts['orderby']) and $atts['orderby']!="" ){	 
		$args['orderby']= $atts['orderby'];
	}

 
	// Meta Query***********************
	$city_mq ='';
	if(isset($atts['city']) AND $atts['city']!=''){
			$city_mq = array(
			'relation' => 'AND',
				array(
					'key'     => 'city',
					'value'   => sanitize_text_field($atts['city']),
					'compare' => 'LIKE'
				),
			);
	}

	$zip_mq='';
	if(isset($atts['zipcode']) AND $atts['zipcode']!=''){
		$zip_mq = array(
			'relation' => 'AND',
				array(
					'key'     => 'postcode',
					'value'   => sanitize_text_field($atts['zipcode']),
					'compare' => 'LIKE'
				),
			);
	}

	$args['meta_query'] = array(
		$city_mq, $zip_mq,
	);
	$filter_query = new WP_Query( $args );

		$div_id=rand(1, 500);

		if ( $filter_query->have_posts() ) : ?>

			<div id="js-grid-filter-<?php echo esc_html($div_id);?>" class="cbp cbp-l-grid-team" >

				<?php
				while ( $filter_query->have_posts() ) : $filter_query->the_post();
				$id = get_the_ID();
				$feature_img='';
				if(has_post_thumbnail()){
					$feature_image = wp_get_attachment_image_src( get_post_thumbnail_id( $id ), 'large' );
					if($feature_image[0]!=""){
						$feature_img =$feature_image[0];
					}
				}else{
					$feature_img= wp_iv_directories_URLPATH."/assets/images/default-directory.jpg";

				}
				$currentCategory=wp_get_object_terms( $id, $current_post_type.'-category');
				$cat_name = (isset($currentCategory[0]->name)?$currentCategory[0]->name:'' );

				?>
				<div class="cbp-item  ">
						<a href="<?php echo get_permalink($id); ?>" class="cbp-caption " rel="nofollow">
							<div class="cbp-caption-defaultWrap">
								<div class="image-container" style="background: url('<?php echo esc_attr($feature_img);?>') center center no-repeat; background-size: cover;">
								</div>
							</div>
							<div class="cbp-caption-activeWrap">
								<div class="cbp-l-caption-alignCenter">
									<div class="cbp-l-caption-body">
										<div class="cbp-l-caption-text"><?php esc_html_e('VIEW DETAIL', 'ivdirectories' ); ?></div>
									</div>
								</div>
							</div>
						</a>
						<a href="<?php echo get_permalink($id); ?>" class="cbp-l-grid-team-name" ><?php echo substr(get_the_title($id),0,28); ?></a>
						<div class="cbp-l-grid-team-position"><?php echo esc_html($cat_name).'&nbsp;'; ?></div>
					</div>
	<?php
				endwhile;
				?>
				</div>
	<?php
		endif;
	?>
	<?php
	wp_enqueue_script('jquery.cubeportfolio', wp_iv_directories_URLPATH . 'assets/cube/js/jquery.cubeportfolio.min.js');

	wp_enqueue_script('iv_directories-filter', wp_iv_directories_URLPATH . 'admin/files/js/listing_filter.js');
	wp_localize_script('iv_directories-filter', 'filterdata', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ),
	'div_id'=> 	esc_html($div_id),	
	'settingnonce'=> wp_create_nonce("settings"),
	'loading_image'		=> '<img src="'.wp_iv_directories_URLPATH.'admin/files/images/loader.gif">',
	) );

	?>	
<?php
}
?>
